﻿using System;
using System.IO;
using System.Linq;
using System.Reflection;
using System.Xml.Serialization;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityInjector;
using UnityInjector.Attributes;

[assembly: AssemblyTitle(COM3D2.ひな形.ひな形.PluginTarget + COM3D2.ひな形.ひな形.PluginName)]
[assembly: AssemblyDescription("")]
[assembly: AssemblyConfiguration("")]
[assembly: AssemblyCompany(COM3D2.ひな形.ひな形.PluginCompany)]
[assembly: AssemblyProduct(COM3D2.ひな形.ひな形.PluginTarget + COM3D2.ひな形.ひな形.PluginName)]
[assembly: AssemblyCopyright(COM3D2.ひな形.ひな形.PluginCopyright)]
[assembly: AssemblyTrademark("")]
[assembly: AssemblyCulture("")]
[assembly: AssemblyVersion(COM3D2.ひな形.ひな形.PluginVersion)]
[assembly: AssemblyFileVersion(COM3D2.ひな形.ひな形.PluginVersion)]

// TODO : namespaceの「ひな形」をプラグイン名に変更する、次行のひな形にキャレット(カーソル)を当ててCtrlを押しながらRを2回押す。
namespace COM3D2.ひな形
{
	[PluginFilter("COM3D2x64"), PluginFilter("COM3D2VRx64"), PluginFilter("COM3D2OHx64"), PluginFilter("COM3D2OHVRx64")]
	[PluginName(ひな形.PluginTarget + ひな形.PluginName)]
	[PluginVersion(ひな形.PluginVersion)]

	// TODO : クラス名の「ひな形」をプラグイン名に変更する、次行のひな形にキャレット(カーソル)を当ててCtrlを押しながらRを2回押す。
	public class ひな形 : PluginBase
	{
		#region プラグイン情報
		/// <summary>
		/// プラグインのターゲット
		/// </summary>
		/// <remarks>
		/// 接頭辞
		/// COM3D2.		オダメ用
		/// </remarks>
		public const string PluginTarget = "COM3D2.";

		/// <summary>
		/// プラグイン名
		/// </summary>
		// TODO : 今回作るプラグイン名に変更
		public const string PluginName = "プラグインの名前を入れる";

		/// <summary>
		/// プラグイン作者名
		/// </summary>
		// TODO : プラグイン作者名を変更
		public const string PluginCompany = "プラグイン作者名を入れる";

		/// <summary>
		/// プラグインコピーライト
		/// </summary>
		// TODO : プラグインコピーライト(作者名と公開年を入れるのが通例)を変更
		public const string PluginCopyright = "コピーライトを入れる";

		/// <summary>
		/// プラグインバージョン
		/// </summary>
		// TODO : バージョンを付ける(バージョンアップ時には忘れず更新する)
		public const string PluginVersion = "1.0.0.0";
		#endregion

		#region 設定関連
		// TODO : 設定保存が不要ならあれば #region 設定関連 をまるっと削除する(その際は LoadConfig の呼び出しも消す)
		/// <summary>
		/// 設定データ
		/// </summary>
		/// <remarks>
		/// 保存したい項目をプロパティで表記する、その際 public で get/set 両方できるものにしておく。
		/// コンストラクタを実装する場合、必ずデフォルトコンストラクタ(引数のないコンストラクタ)をpublicで実装すること。
		/// ※上記注意事項は XmlSerializer でシリアライズするための注意事項です（XmlSerializerで処理をしているため）。
		/// </remarks>
		public class Config
		{
			#region UI関連
			/// <summary>
			/// 起動ホットキー
			/// </summary>
			public string HotKeyUIOpenClose { get; set; }
			/// <summary>
			/// 起動ホットキー[Ctrl押しながら]
			/// </summary>
			public bool HotKeyUIOpenCloseCtrl { get; set; }
			/// <summary>
			/// 起動ホットキー[Shift押しながら]
			/// </summary>
			public bool HotKeyUIOpenCloseShift { get; set; }
			/// <summary>
			/// 起動ホットキー[Alt押しながら]
			/// </summary>
			public bool HotKeyUIOpenCloseAlt { get; set; }
			#endregion

			/// <summary>
			/// コンストラクタ
			/// </summary>
			/// <remarks>
			/// 既定値設定など
			/// </remarks>
			public Config()
			{
				#region UI関連
				// 既定の起動ホットキー
				// TODO : とりあえずAlt+F1にしているので修正する
				this.HotKeyUIOpenClose = "F1";
				this.HotKeyUIOpenCloseCtrl = false;
				this.HotKeyUIOpenCloseShift = false;
				this.HotKeyUIOpenCloseAlt = true;
				#endregion
			}
		}

		/// <summary>
		/// 設定ファイルのパス
		/// </summary>
		private string configPath;

		/// <summary>
		/// 設定
		/// </summary>
		private Config config;

		private void LoadConfig()
		{
			// 設定読み込み
			var pathInjector = Path.GetDirectoryName(Assembly.GetExecutingAssembly().Location);
			var pathConfig = Path.Combine(pathInjector, "Config");
			this.configPath = Path.Combine(pathConfig, ひな形.PluginName + ".xml");
			try
			{
				if (File.Exists(this.configPath))
				{
					var serializer = new XmlSerializer(typeof(Config));
					using (var reader = new StreamReader(this.configPath))
					{
						this.config = (Config)serializer.Deserialize(reader);
					}
				}
			}
			catch { }
			// 設定が取れなかったら既定値
			if (this.config == null)
			{
				// 新規で設定を作成して
				this.config = new Config();
				// 保存
				this.WriteConfig();
			}
		}

		/// <summary>
		/// 設定保存
		/// </summary>
		private void WriteConfig()
		{
			try
			{
				var serializer = new XmlSerializer(typeof(Config));
				using (var writer = new StreamWriter(this.configPath))
				{
					serializer.Serialize(writer, this.config);
				}
			}
			catch { }
		}
		#endregion

		#region UI関連
		// TODO : UIを使わないなら #region UI関連 をまるっと削除する
		/// <summary>
		/// UIのID
		/// </summary>
		// TODO : 他と当たるとまずいので、適当な値に変更しておくこと
		private const int uiId = 0x12345678;
		/// <summary>
		/// ウィンドウのスタイル
		/// </summary>
		private readonly GUIStyle uiStyleWindow = new GUIStyle("box")
		{
			fontSize = 12,
			fontStyle = UnityEngine.FontStyle.Normal,
			alignment = TextAnchor.MiddleCenter
		};
		/// <summary>
		/// ラベルのスタイル
		/// </summary>
		private readonly GUIStyle uiStyleLabel = new GUIStyle("label")
		{
			fontSize = 12,
			fontStyle = UnityEngine.FontStyle.Normal,
			alignment = TextAnchor.MiddleLeft
		};
		/// <summary>
		/// ボタンのスタイル
		/// </summary>
		private readonly GUIStyle uiStyleButton = new GUIStyle("button")
		{
			fontSize = 12,
			fontStyle = UnityEngine.FontStyle.Normal,
			alignment = TextAnchor.MiddleCenter
		};
		/// <summary>
		/// ボタン(小)のスタイル
		/// </summary>
		private readonly GUIStyle uiStyleMiniButton = new GUIStyle("button")
		{
			fontSize = 12,
			fontStyle = UnityEngine.FontStyle.Normal,
			alignment = TextAnchor.MiddleCenter,
			fixedWidth = 20f
		};
		/// <summary>
		/// タイトル文字列
		/// </summary>
		public string uiTitle = PluginName + "(" + PluginVersion + ")";
		/// <summary>
		/// 幅
		/// </summary>
		/// TODO : 必要に応じて変更
		public const int uiWidth = 320;
		/// <summary>
		/// 高さ
		/// </summary>
		/// TODO : 必要に応じて変更
		public const int uiHeight = 36;
		/// <summary>
		/// UIの位置
		/// </summary>
		private Rect uiRect = new Rect((float)(Screen.width - uiWidth) / 2f, (float)(Screen.height - uiHeight) / 2f, (float)uiWidth, (float)uiHeight);
		/// <summary>
		/// UI表示中かどうかのフラグ
		/// </summary>
		private bool uiOpen = false;
		/// <summary>
		/// 開閉キーが押下中かどうかのフラグ
		/// </summary>
		private bool keyOpenCloseDown = false;

		/// <summary>
		/// 選択中メイド
		/// </summary>
		private Maid maid;

		/// <summary>
		/// GUI
		/// </summary>
		public void OnGUI()
		{
			try
			{
				// 表示<->非表示を切り替え
				// 指定された文字列をKeyCodeに変換する
				var keyOpenClose = (KeyCode)Enum.Parse(typeof(KeyCode), config.HotKeyUIOpenClose, true);
				// Ctrl,Shift,Altの押下状態を取得する
				var ctrl = Input.GetKey(KeyCode.LeftControl) || Input.GetKey(KeyCode.RightControl);
				var shift = Input.GetKey(KeyCode.LeftShift) || Input.GetKey(KeyCode.RightShift);
				var alt = Input.GetKey(KeyCode.LeftAlt) || Input.GetKey(KeyCode.RightAlt);
				if (this.config.HotKeyUIOpenCloseCtrl == ctrl &&
					this.config.HotKeyUIOpenCloseShift == shift &&
					this.config.HotKeyUIOpenCloseAlt == alt &&
					Input.GetKey(keyOpenClose))
				{
					if (!this.keyOpenCloseDown)
					{
						// 押されていない状態から押されたときのみ、表示<->非表示を切り替える
						this.uiOpen = !this.uiOpen;
						this.keyOpenCloseDown = true;
					}
				}
				else
				{
					this.keyOpenCloseDown = false;
				}
				// UI処理
				if (this.uiOpen)
				{
					this.uiRect = GUILayout.Window(uiId, this.uiRect, new GUI.WindowFunction(WindowFunction), String.Empty, this.uiStyleWindow);
				}
			}
			catch (Exception ex)
			{
				// 例外発生時
				ConsoleLog.Error("OnGUI\r\n{0}", ex.ToString());
			}
		}

		/// <summary>
		/// ウィンドウ処理
		/// </summary>
		/// <param name="id">ウィンドウID</param>
		protected void WindowFunction(int id)
		{
			try
			{
				// メイド選択処理
				// 表示中のメイドを取得する
				var maids = GameMain
					.Instance
					.CharacterMgr
					.GetStockMaidList()
					.Where(maid =>
						maid != null &&             // 念のためのnullチェック①
						maid.status != null &&      // 念のためのnullチェック②
						maid.body0 != null &&       // ボディがあるかどうか(表示されている場合あるはず)
						maid.Visible)               // 表示されているかどうか
					.ToArray();
				// 縦方向レイアウト開始({}←は不要だが対がわかりやすいので入れておく)
				GUILayout.BeginVertical();
				{
					// タイトル部表示
					GUILayout.BeginHorizontal();
					{
						GUILayout.Box(String.Format(this.uiTitle, this.uiStyleWindow));
					}
					GUILayout.EndHorizontal();
					// 横方向レイアウト開始 - [ < ][ > ]メイド名を水平に並べる
					GUILayout.BeginHorizontal();
					{
						// 次のメイドを選択する処理
						Maid nextMaid(Maid currentMaid)
						{
							// 表示中メイドがいない場合、選択できない
							if (maids.Length == 0)
							{
								return null;
							}
							// メイドが選択されている場合
							if (currentMaid != null)
							{
								// 表示中メイド(末尾のメイドは除外)から選択中のメイドを探して次のメイドを選択する
								for (var index = 0; index < (maids.Length - 1); index++)
								{
									if (maids[index].status.guid == currentMaid.status.guid)
										return maids[index + 1];
								}
							}
							// 選択中のメイドがいない、または末尾のメイドの場合は先頭のメイドを選択する
							return maids[0];
						}
						// 前のメイドを選択する処理
						Maid prevMaid(Maid currentMaid)
						{
							// 表示中メイドがいない場合、選択できない
							if (maids.Length == 0)
							{
								return null;
							}
							// メイドが選択されている場合
							if (currentMaid != null)
							{
								// 表示中メイド(先頭のメイドは除外)から選択中のメイドを探して前のメイドを選択する
								for (var index = maids.Length - 1; 0 < index; index--)
								{
									if (maids[index].status.guid == currentMaid.status.guid)
										return maids[index - 1];
								}
							}
							// 選択中のメイドがいない、または先頭のメイドの場合は末尾のメイドを選択する
							return maids[maids.Length - 1];
						}
						// 選択されていたメイドが表示メイドの中からいなくなっている(非表示になった)かどうかチェック
						if (!maids.Contains(this.maid))
						{
							// いなくなっているので選択を解除する
							this.maid = null;
						}
						// [ < ]ボタン
						if (GUILayout.Button("<", this.uiStyleMiniButton))
							this.maid = prevMaid(this.maid);
						// [ > ]ボタン
						if (GUILayout.Button(">", this.uiStyleMiniButton))
							this.maid = nextMaid(this.maid);
						// メイド名
						if (this.maid != null)
						{
							// メイドが選択されている
							GUILayout.Label(this.maid.status.fullNameJpStyle, this.uiStyleLabel);
						}
						else
						{
							// メイドが選択されていない
							GUILayout.Label("未選択", this.uiStyleLabel);
						}
					}
					GUILayout.EndHorizontal();
					// 横方向レイアウト開始 - ボタン1個置く
					GUILayout.BeginHorizontal();
					{
						// [ 実行 ]ボタン
						if (GUILayout.Button("実行", this.uiStyleButton) && this.maid != null)
						{
							// TODO : 実行ボタン押下時の処理を記述(ひな形ではログを出力するだけ)
							ConsoleLog.Information("実行されたメイドさんは{0}。", maid.status.fullNameJpStyle);
						}
					}
					GUILayout.EndHorizontal();
				}
				GUILayout.EndVertical();
				// ドラッグでのウィンドウ移動を行わせる
				GUI.DragWindow();
			}
			catch (Exception ex)
			{
				// 例外発生時
				ConsoleLog.Error("WindowFunction\r\n{0}", ex.ToString());
			}
		}
		#endregion

		/// <summary>
		/// おはよう
		/// </summary>
		public void Awake()
		{
			ConsoleLog.Information("Awake()");

			// シーンが変わってもアンロードされなくする(プラグインは原則必須)
			UnityEngine.GameObject.DontDestroyOnLoad(this);

			// 設定読み込み
			LoadConfig();
		}

		/// <summary>
		/// 有効化
		/// </summary>
		// TODO : 不要なら削除してよい。
		public void OnEnable()
		{
			ConsoleLog.Information("OnEnable()");

			// シーンの出入りタイミングで処理を行いたい場合以下のコードを残す
			// シーンに入ったときの処理を登録
			SceneManager.sceneLoaded += this.OnSceneLoaded;
			// シーンから出たときの処理を登録
			SceneManager.sceneUnloaded += this.OnSceneUnloaded;
		}

		/// <summary>
		/// 無効化
		/// </summary>
		// TODO : 不要なら削除してよい。
		public void OnDisable()
		{
			ConsoleLog.Information("OnDisable()");
		}

		/// <summary>
		/// 開始
		/// </summary>
		// TODO : 不要なら削除してよい。
		public void Start()
		{
			ConsoleLog.Information("Start()");
		}

		/// <summary>
		/// 終了
		/// </summary>
		// TODO : 不要なら削除してよい。
		public void Stop()
		{
			ConsoleLog.Information("Stop()");
		}

		/// <summary>
		/// シーンはいるとき
		/// </summary>
		/// <param name="scene">シーン</param>
		/// <param name="sceneMode">シーンモード</param>
		/// <remarks>
		/// SceneManagerへの登録が必要(ひな型ではOnEnable()で実行しています)
		/// </remarks>
		// TODO : 不要なら削除してよい。(削除する場合はOnEnableの登録行も消す。)
		public void OnSceneLoaded(Scene scene, LoadSceneMode sceneMode)
		{
			ConsoleLog.Information("OnSceneLoaded()");
		}

		/// <summary>
		/// シーンでるとき
		/// </summary>
		/// <param name="scene">シーン</param>
		/// <remarks>
		/// SceneManagerへの登録が必要(ひな型ではOnEnable()で実行しています)
		/// </remarks>
		// TODO : 不要なら削除してよい。(削除する場合はOnEnableの登録行も消す。)
		public void OnSceneUnloaded(Scene scene)
		{
			ConsoleLog.Information("OnSceneUnLoaded()");
		}

		/// <summary>
		/// 毎フレーム処理
		/// </summary>
		/// <remarks>
		/// 毎フレーム処理なので重い処理を書くとオダメが重くなるので注意
		/// TODO : 不要ならまるっと削除する。
		///</remarks>
		public void Update()
		{
		}
	}

	#region ログ
	/// <summary>
	/// 適当なログラッパー
	/// </summary>
	internal static class ConsoleLog
	{
		/// <summary>
		/// コンストラクタ
		/// </summary>
		/// <remarks>
		/// ふわっとプラグイン名とバージョンを取れたら取る
		/// </remarks>
		static ConsoleLog()
		{
			foreach (var type in Assembly.GetExecutingAssembly().GetTypes())
			{
				PluginName = ((PluginNameAttribute)Attribute.GetCustomAttribute(type, typeof(PluginNameAttribute)))?.Name?.Split('.').Where(item => String.Compare(item, "plugin", true) != 0).LastOrDefault()?.Trim();
				PluginVersion = ((PluginVersionAttribute)Attribute.GetCustomAttribute(type, typeof(PluginVersionAttribute)))?.Version?.Trim();
				if (!String.IsNullOrEmpty(PluginName))
					break;
			}
		}

		private static PluginBase plugin;
		/// <summary>
		/// プラグイン指定
		/// </summary>
		/// <remarks>
		/// ふわっとプラグイン名とバージョンを取れたら取る
		/// </remarks>
		internal static PluginBase Plugin
		{
			get { return plugin; }
			set
			{
				if ((plugin = value) != null)
				{
					PluginName = ((PluginNameAttribute)Attribute.GetCustomAttribute(plugin.GetType(), typeof(PluginNameAttribute)))?.Name?.Split('.').Where(item => String.Compare(item, "plugin", true) != 0).LastOrDefault()?.Trim();
					PluginVersion = ((PluginVersionAttribute)Attribute.GetCustomAttribute(plugin.GetType(), typeof(PluginVersionAttribute)))?.Version?.Trim();
				}
			}
		}

		private static string pluginName;
		/// <summary>
		/// プラグイン名
		/// </summary>
		/// <remarks>
		/// プラグイン名直接指定
		/// </remarks>
		internal static string PluginName { get { return pluginName; } set { pluginName = value; UpdatePrefix(); } }

		private static string pluginVersion;
		/// <summary>
		/// プラグインバージョン
		/// </summary>
		/// <remarks>
		/// プラグインバージョン直接指定
		/// </remarks>
		internal static string PluginVersion { get { return pluginVersion; } set { pluginVersion = value; UpdatePrefix(); } }

		/// <summary>
		/// ログに付けるプレフィックス
		/// </summary>
		private static string logPrefix;

		/// <summary>
		/// ログに付けるプレフィックス更新
		/// </summary>
		private static void UpdatePrefix() => logPrefix = String.IsNullOrEmpty(PluginName) ? String.Empty : String.IsNullOrEmpty(PluginVersion) ? String.Format("{0} : ", PluginName) : String.Format("{0}[{1}] : ", PluginName, PluginVersion);

		/// <summary>
		/// 情報ログ出力
		/// </summary>
		/// <param name="format">書式</param>
		/// <param name="args">書式に対するパラメータ</param>
		internal static void Information(string format, params object[] args)
		{
			try
			{
				ConsoleLog.Information(String.Format(format, args));
			}
			catch
			{
				ConsoleLog.Error(String.Format("ConsoleLog[Information] フォーマットエラー\r\n{0}", format));
			}
		}
		/// <summary>
		/// 警告ログ出力
		/// </summary>
		/// <param name="format">書式</param>
		/// <param name="args">書式に対するパラメータ</param>
		internal static void Warning(string format, params object[] args)
		{
			try
			{
				ConsoleLog.Warning(String.Format(format, args));
			}
			catch
			{
				ConsoleLog.Error(String.Format("ConsoleLog[Warning] フォーマットエラー\r\n{0}", format));
			}
		}
		/// <summary>
		/// エラーログ出力
		/// </summary>
		/// <param name="format">書式</param>
		/// <param name="args">書式に対するパラメータ</param>
		internal static void Error(string format, params object[] args)
		{
			try
			{
				ConsoleLog.Error(String.Format(format, args));
			}
			catch
			{
				ConsoleLog.Error(String.Format("ConsoleLog[Error] フォーマットエラー\r\n{0}", format));
			}
		}
		/// <summary>
		/// 情報ログ出力
		/// </summary>
		/// <param name="log">ログ本文</param>
		internal static void Information(string log)
		{
			try
			{
				Debug.Log(String.Format("{0}{1}", logPrefix, log));
			}
			catch { }
		}
		/// <summary>
		/// 警告ログ出力
		/// </summary>
		/// <param name="log">ログ本文</param>
		internal static void Warning(string log)
		{
			try
			{
				Debug.LogWarning(String.Format("{0}{1}", logPrefix, log));
			}
			catch { }
		}
		/// <summary>
		/// エラーログ出力
		/// </summary>
		/// <param name="log">ログ本文</param>
		internal static void Error(string log)
		{
			try
			{
				Debug.LogError(String.Format("{0}{1}", logPrefix, log));
			}
			catch { }
		}
	}
	#endregion
}
